% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgsims.R
\name{mrgsims_modify}
\alias{mrgsims_modify}
\alias{mutate_sims}
\alias{select_sims}
\alias{filter_sims}
\title{Methods for modifying mrgsims objects}
\usage{
mutate_sims(.data, ...)

select_sims(.data, ...)

filter_sims(.data, ...)
}
\arguments{
\item{.data}{a mrgsims object.}

\item{...}{other arguments passed to the \code{dplyr} functions.}
}
\description{
These functions modify the simulated data in an mrgsims object and return
the modified object.  Contrast with the functions in \link{mrgsims_dplyr}.
}
\examples{

out <- mrgsim(house(), events = ev(amt = 100))

filter_sims(out, time > 2)

mutate_sims(out, label = "abc")

select_sims(out, RESP, CP)

}
\seealso{
\link{mrgsims_dplyr}
}
