% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.R
\name{as.data.frame.estimate_contrasts}
\alias{as.data.frame.estimate_contrasts}
\title{Converting modelbased-objects into raw data frames}
\usage{
\method{as.data.frame}{estimate_contrasts}(
  x,
  row.names = NULL,
  optional = FALSE,
  ...,
  stringsAsFactors = FALSE,
  use_responsename = FALSE,
  preserve_names = TRUE
)
}
\arguments{
\item{x}{An object returned by the different \verb{estimate_*()} functions.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and
    converting column names (to syntactic names: see
    \code{\link[base]{make.names}}) is optional.  Note that all of \R's
    \pkg{base} package \code{as.data.frame()} methods use
    \code{optional} only for column names treatment, basically with the
    meaning of \code{\link[base]{data.frame}(*, check.names = !optional)}.
    See also the \code{make.names} argument of the \code{matrix} method.}

\item{...}{Arguments passed to the \code{data.frame} method of \code{as.data.frame()}.}

\item{stringsAsFactors}{logical: should the character vector be converted
    to a factor?}

\item{use_responsename}{Logical, if \code{TRUE}, the response variable name is used
as column name for the estimate column (if available). If \code{FALSE} (default),
the column is named \code{"Coefficient"}.}

\item{preserve_names}{Logical, if \code{TRUE} (default), the original column names
are preserved. If \code{FALSE}, the estimate column is renamed to either the
response name (if \code{use_responsename = TRUE}) or to \code{"Coefficient"}.}
}
\value{
A data frame.
}
\description{
\code{as.data.frame()} method for \strong{modelbased} objects. Can be used to return
a "raw" data frame without attributes and with standardized column names.
By default, the original column names are preserved, to avoid unexpected
changes, but this can be changed with the \code{preserve_names} argument.
}
\examples{
\dontshow{if (insight::check_if_installed("marginaleffects", quietly = TRUE)) withAutoprint(\{ # examplesIf}
model <- lm(Petal.Length ~ Species, data = iris)
out <- estimate_means(model, "Species")

# default
print(out)

as.data.frame(out)

as.data.frame(out, preserve_names = FALSE)

as.data.frame(out, preserve_names = FALSE, use_responsename = TRUE)
\dontshow{\}) # examplesIf}
}
