% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazy_tensor.R
\name{as_lazy_tensor}
\alias{as_lazy_tensor}
\alias{as_lazy_tensor.dataset}
\title{Convert to Lazy Tensor}
\usage{
as_lazy_tensor(x, ...)

\method{as_lazy_tensor}{dataset}(x, dataset_shapes = NULL, ids = NULL, ...)
}
\arguments{
\item{x}{(any)\cr
Object to convert to a \code{\link{lazy_tensor}}}

\item{...}{(any)\cr
Additional arguments passed to the method.}

\item{dataset_shapes}{(named \code{list()} of (\code{integer()} or \code{NULL}))\cr
The shapes of the output.
Names are the elements of the list returned by the dataset.
If the shape is not \code{NULL} (unknown, e.g. for images of different sizes) the first dimension must be \code{NA} to
indicate the batch dimension.}

\item{ids}{(\code{integer()})\cr
Which ids to include in the lazy tensor.}
}
\description{
Convert a object to a \code{\link{lazy_tensor}}.
}
\examples{
\dontshow{if (torch::torch_is_installed()) withAutoprint(\{ # examplesIf}
iris_ds = dataset("iris",
  initialize = function() {
    self$iris = iris[, -5]
  },
  .getbatch = function(i) {
    list(x = torch_tensor(as.matrix(self$iris[i, ])))
  },
  .length = function() nrow(self$iris)
)()
# no need to specify the dataset shapes as they can be inferred from the .getbatch method
# only first 5 observations
as_lazy_tensor(iris_ds, ids = 1:5)
# all observations
head(as_lazy_tensor(iris_ds))

iris_ds2 = dataset("iris",
  initialize = function() self$iris = iris[, -5],
  .getitem = function(i) list(x = torch_tensor(as.numeric(self$iris[i, ]))),
  .length = function() nrow(self$iris)
)()
# if .getitem is implemented we cannot infer the shapes as they might vary,
# so we have to annotate them explicitly
as_lazy_tensor(iris_ds2, dataset_shapes = list(x = c(NA, 4L)))[1:5]

# Convert a matrix
lt = as_lazy_tensor(matrix(rnorm(100), nrow = 20))
materialize(lt[1:5], rbind = TRUE)
\dontshow{\}) # examplesIf}
}
