% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskGeneratorSimplex.R
\name{mlr_task_generators_simplex}
\alias{mlr_task_generators_simplex}
\alias{TaskGeneratorSimplex}
\title{Simplex Classification Task Generator}
\description{
A \link{TaskGenerator} for the simplex task in \code{\link[mlbench:mlbench.simplex]{mlbench::mlbench.simplex()}}.

Note that the generator implemented in \CRANpkg{mlbench} returns
fewer samples than requested.
}
\section{Dictionary}{

This \link{TaskGenerator} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_task_generators} or with the associated sugar function \code{\link[=tgen]{tgen()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_task_generators$get("simplex")
tgen("simplex")
}\if{html}{\out{</div>}}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   center \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   d \tab integer \tab 3 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   sd \tab numeric \tab 0.1 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   sides \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
}
}

\examples{
generator = tgen("simplex")
plot(generator, n = 200)

task = generator$generate(200)
str(task$data())
}
\seealso{
\itemize{
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=TaskGenerator]{TaskGenerators}: \link{mlr_task_generators}
\item \code{as.data.table(mlr_task_generators)}  for a table of available \link[=TaskGenerator]{TaskGenerators} in the running session (depending on the loaded packages).
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
}

Other TaskGenerator: 
\code{\link{TaskGenerator}},
\code{\link{mlr_task_generators}},
\code{\link{mlr_task_generators_2dnormals}},
\code{\link{mlr_task_generators_cassini}},
\code{\link{mlr_task_generators_circle}},
\code{\link{mlr_task_generators_friedman1}},
\code{\link{mlr_task_generators_moons}},
\code{\link{mlr_task_generators_peak}},
\code{\link{mlr_task_generators_smiley}},
\code{\link{mlr_task_generators_spirals}},
\code{\link{mlr_task_generators_xor}}
}
\concept{TaskGenerator}
\section{Super class}{
\code{\link[mlr3:TaskGenerator]{mlr3::TaskGenerator}} -> \code{TaskGeneratorSimplex}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TaskGeneratorSimplex-new}{\code{TaskGeneratorSimplex$new()}}
\item \href{#method-TaskGeneratorSimplex-plot}{\code{TaskGeneratorSimplex$plot()}}
\item \href{#method-TaskGeneratorSimplex-clone}{\code{TaskGeneratorSimplex$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="format"><a href='../../mlr3/html/TaskGenerator.html#method-TaskGenerator-format'><code>mlr3::TaskGenerator$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="generate"><a href='../../mlr3/html/TaskGenerator.html#method-TaskGenerator-generate'><code>mlr3::TaskGenerator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="print"><a href='../../mlr3/html/TaskGenerator.html#method-TaskGenerator-print'><code>mlr3::TaskGenerator$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaskGeneratorSimplex-new"></a>}}
\if{latex}{\out{\hypertarget{method-TaskGeneratorSimplex-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGeneratorSimplex$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaskGeneratorSimplex-plot"></a>}}
\if{latex}{\out{\hypertarget{method-TaskGeneratorSimplex-plot}{}}}
\subsection{Method \code{plot()}}{
Creates a simple plot of generated data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGeneratorSimplex$plot(n = 200L, pch = 19L, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(\code{integer(1)})\cr
Number of samples to draw for the plot. Default is 200.}

\item{\code{pch}}{(\code{integer(1)})\cr
Point char. Passed to \code{\link[=plot]{plot()}}.}

\item{\code{...}}{(any)\cr
Additional arguments passed to \code{\link[=plot]{plot()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaskGeneratorSimplex-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TaskGeneratorSimplex-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGeneratorSimplex$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
