% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{class}
\name{mgwrsar-class}
\alias{mgwrsar-class}
\title{Class of mgwrsar Model.}
\description{
A S4 class to represent the results of MGWRSAR, TDS-MGWR and related spatial models.
}
\section{Slots}{

\describe{
\item{\code{Betav}}{matrix. The estimated varying coefficients, dimension (n, kv).}

\item{\code{Betac}}{numeric. The estimated constant coefficients, length kc.}

\item{\code{Model}}{character. The type of model (e.g., "GWR", "MGWR", "SAR", "tds_mgwr").}

\item{\code{fixed_vars}}{character. A vector with names of spatially constant covariates.}

\item{\code{Y}}{numeric. The dependent variable.}

\item{\code{XC}}{matrix. The explanatory variables with constant coefficients.}

\item{\code{XV}}{matrix. The explanatory variables with varying coefficients.}

\item{\code{X}}{matrix. All explanatory variables.}

\item{\code{W}}{Matrix. The spatial weight matrix for spatial dependence (row-standardized).}

\item{\code{isgcv}}{logical. Indicates if Leave-One-Out Cross-Validation (LOOCV) has been computed.}

\item{\code{edf}}{numeric. The estimated effective degrees of freedom.}

\item{\code{formula}}{formula. The model formula.}

\item{\code{data}}{data.frame. The dataframe used for computation.}

\item{\code{Method}}{character. The estimation technique for spatial dependence models ('2SLS' or 'B2SLS'). Default is '2SLS'.}

\item{\code{coords}}{matrix. The spatial coordinates of observations.}

\item{\code{H}}{numeric. The bandwidth vector (spatial).}

\item{\code{Ht}}{numeric. The bandwidth vector (temporal), if applicable.}

\item{\code{kernels}}{character. The kernel type(s) used (e.g., 'gauss', 'bisq').}

\item{\code{adaptive}}{logical. Indicates if an adaptive kernel (nearest neighbors) was used.}

\item{\code{Type}}{character. The type of Generalized Kernel Product ('GD' for spatial, 'GDT' for spatio-temporal).}

\item{\code{TP}}{numeric. Indices of target points (if a subset was used).}

\item{\code{SSRtp}}{numeric. The residual sum of squares calculated only on target points.}

\item{\code{SSR}}{numeric. The total residual sum of squares.}

\item{\code{residuals}}{numeric. The vector of residuals.}

\item{\code{fit}}{numeric. The vector of fitted values.}

\item{\code{pred}}{numeric. The vector of predicted values (out-of-sample).}

\item{\code{sev}}{matrix. Local standard errors of varying coefficients.}

\item{\code{se}}{numeric. Standard errors of constant coefficients.}

\item{\code{tS}}{numeric. The trace of the Hat matrix (effective number of parameters).}

\item{\code{Shat}}{matrix. The Hat matrix (or approximation).}

\item{\code{R_k}}{list. List of partial Hat matrices by covariate (for MGWR inference).}

\item{\code{h_w}}{numeric. The bandwidth value used for computing the spatial weight matrix W. Default is 0.}

\item{\code{kernel_w}}{character. The kernel type used for computing W. Default is NULL.}

\item{\code{RMSE}}{numeric. Root Mean Square Error (on training data).}

\item{\code{RMSEtp}}{numeric. Root Mean Square Error computed on target points.}

\item{\code{CV}}{numeric. Leave-One-Out Cross-Validation score.}

\item{\code{AIC}}{numeric. Akaike Information Criterion.}

\item{\code{AICc}}{numeric. Corrected Akaike Information Criterion.}

\item{\code{AICctp}}{numeric. Corrected AIC for target points.}

\item{\code{BIC}}{numeric. Bayesian Information Criterion.}

\item{\code{R2}}{numeric. R-squared.}

\item{\code{R2_adj}}{numeric. Adjusted R-squared.}

\item{\code{get_ts}}{logical. Indicates if the trace of the Hat matrix (Tr(S)) was stored.}

\item{\code{NN}}{numeric. The maximum number of neighbors used for weight computation (truncation parameter).}

\item{\code{ncore}}{numeric. Number of CPU cores used.}

\item{\code{mycall}}{call. The original function call.}

\item{\code{ctime}}{numeric. Computation time in seconds.}

\item{\code{HRMSE}}{matrix. History of RMSE values (for iterative algorithms like backfitting).}

\item{\code{HBETA}}{list. History of estimated Beta coefficients at each iteration.}

\item{\code{loglik}}{numeric. Log-likelihood value.}

\item{\code{G}}{list. List containing neighboring indices and distances (knn object).}

\item{\code{V}}{numeric. Sequence of spatial bandwidths tested (for TDS algorithms).}

\item{\code{Vt}}{numeric. Sequence of temporal bandwidths tested (for TDS algorithms).}

\item{\code{Z}}{numeric. Temporal or auxiliary variable for GDT kernel type.}

\item{\code{TS}}{numeric. Diagonal elements of the Hat Matrix.}

\item{\code{alpha}}{numeric. Ratio parameter for GDT kernels (balancing space and time).}

\item{\code{HM}}{matrix. Matrix of optimal bandwidths per covariate (for TDS).}

\item{\code{HKmin}}{numeric. Minimum allowed bandwidth per covariate (for TDS).}

\item{\code{HKMIN}}{list. List of minimum bandwidths per covariate for spatio-temporal models (TDS).}

\item{\code{isolated_idx}}{numeric. Indices of observations without sufficient neighbors.}

\item{\code{my_crs}}{ANY. Coordinate Reference System (CRS) information.}
}}

