% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transpile.R
\name{transpile_stata}
\alias{transpile_stata}
\title{Transpile a STATA .do file to metasurvey steps}
\usage{
transpile_stata(do_file, survey_type = "ech", user = "iecon", strict = FALSE)
}
\arguments{
\item{do_file}{Path to a STATA .do file}

\item{survey_type}{Survey type (default "ech")}

\item{user}{Author name for the recipe}

\item{strict}{If TRUE, stops on untranslatable commands;
if FALSE, inserts MANUAL_REVIEW comments as warnings}
}
\value{
A list with:
\itemize{
\item steps: character vector of step call strings
\item labels: list with var_labels and val_labels (if label
commands found)
\item warnings: character vector of MANUAL_REVIEW items
\item stats: list with command counts
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Parses a STATA .do file and translates its commands into
metasurvey step call strings suitable for use in Recipe objects.
}
\examples{
\donttest{
tf <- tempfile(fileext = ".do")
writeLines(c("gen age2 = edad^2", "replace sexo = 1 if sexo == ."), tf)
result <- transpile_stata(tf)
result$steps
result$stats
}
}
\seealso{
Other transpiler: 
\code{\link{parse_do_file}()},
\code{\link{parse_stata_labels}()},
\code{\link{transpile_coverage}()},
\code{\link{transpile_stata_module}()}
}
\concept{transpiler}
