% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{survey_to_data_frame}
\alias{survey_to_data_frame}
\title{survey_to_data_frame}
\usage{
survey_to_data_frame(svy)
}
\arguments{
\item{svy}{Survey object}
}
\value{
data.frame
}
\description{
Convert survey to data.frame
}
\examples{
dt <- data.table::data.table(
  id = 1:5, age = c(25, 30, 45, 50, 60),
  w = rep(1, 5)
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "ech",
  psu = NULL, engine = "data.table", weight = add_weight(annual = "w")
)
df <- survey_to_data_frame(svy)
class(df) # "data.frame"
}
\seealso{
Other survey-objects: 
\code{\link{Survey}},
\code{\link{cat_design}()},
\code{\link{cat_design_type}()},
\code{\link{get_data}()},
\code{\link{get_metadata}()},
\code{\link{has_design}()},
\code{\link{has_recipes}()},
\code{\link{has_steps}()},
\code{\link{is_baked}()},
\code{\link{set_data}()},
\code{\link{survey_empty}()},
\code{\link{survey_to_datatable}()},
\code{\link{survey_to_tibble}()}
}
\concept{survey-objects}
\keyword{survey}
