% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{set_data}
\alias{set_data}
\title{Set data on a Survey}
\usage{
set_data(svy, data, .copy = FALSE)
}
\arguments{
\item{svy}{Survey object}

\item{data}{A data.frame or data.table with survey microdata}

\item{.copy}{Logical; if TRUE, clone the Survey before
modifying (default FALSE)}
}
\value{
The Survey object (invisibly). If
\code{.copy=TRUE}, returns a new clone.
}
\description{
Tidy wrapper for \code{svy$set_data(data)}.
}
\examples{
dt <- data.table::data.table(id = 1:5, x = rnorm(5), w = rep(1, 5))
svy <- Survey$new(
  data = dt, edition = "2023", type = "test",
  psu = NULL, engine = "data.table", weight = add_weight(annual = "w")
)
new_dt <- data.table::data.table(id = 1:3, x = rnorm(3), w = rep(1, 3))
svy <- set_data(svy, new_dt)
}
\seealso{
Other survey-objects: 
\code{\link{Survey}},
\code{\link{cat_design}()},
\code{\link{cat_design_type}()},
\code{\link{get_data}()},
\code{\link{get_metadata}()},
\code{\link{has_design}()},
\code{\link{has_recipes}()},
\code{\link{has_steps}()},
\code{\link{is_baked}()},
\code{\link{survey_empty}()},
\code{\link{survey_to_data_frame}()},
\code{\link{survey_to_datatable}()},
\code{\link{survey_to_tibble}()}
}
\concept{survey-objects}
