% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecipeWorkflow.R
\name{save_workflow}
\alias{save_workflow}
\title{Save a RecipeWorkflow to a JSON file}
\usage{
save_workflow(wf, file)
}
\arguments{
\item{wf}{A RecipeWorkflow object}

\item{file}{Character file path}
}
\value{
NULL (called for side-effect)
}
\description{
Save a RecipeWorkflow to a JSON file
}
\examples{
wf <- RecipeWorkflow$new(
  name = "Example", description = "Test",
  survey_type = "ech", edition = "2023",
  recipe_ids = "r_001", estimation_type = "svymean"
)
f <- tempfile(fileext = ".json")
save_workflow(wf, f)
}
\seealso{
Other workflows: 
\code{\link{RecipeWorkflow-class}},
\code{\link{evaluate_cv}()},
\code{\link{print.RecipeWorkflow}()},
\code{\link{publish_workflow}()},
\code{\link{read_workflow}()},
\code{\link{reproduce_workflow}()},
\code{\link{workflow}()},
\code{\link{workflow_from_list}()},
\code{\link{workflow_table}()}
}
\concept{workflows}
\keyword{workflow}
