% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recipes.R
\name{recipe}
\alias{recipe}
\title{Create a survey data transformation recipe}
\usage{
recipe(...)
}
\arguments{
\item{...}{Required metadata and optional steps. Required parameters:
\itemize{
\item \code{name}: Descriptive name for the recipe
\item \code{user}: User/author creating the recipe
\item \code{svy}: Base Survey object
(use \code{survey_empty()} for generic recipes)
\item \code{description}: Detailed description of the recipe's purpose
}
Optional parameters include data transformation steps.}
}
\value{
A \code{Recipe} object containing metadata, transformation steps,
dependency information, and default engine configuration.
}
\description{
Creates a Recipe object that encapsulates a sequence of data transformations
that can be applied to surveys in a reproducible manner. Recipes allow
documenting, sharing, and reusing data processing workflows.
}
\details{
Recipes are essential for:
\itemize{
\item Reproducibility: Ensure transformations are applied consistently
\item Documentation: Keep a record of what
transformations are performed and why
\item Collaboration: Share workflows between users and teams
\item Versioning: Maintain different processing
versions for different editions
\item Automation: Apply complex transformations automatically
}

Steps included in the recipe can be any combination of
\code{step_compute}, \code{step_recode}, or other transformation steps.

Recipes can be saved with \code{save_recipe()}, loaded with
\code{read_recipe()}, and applied automatically with \code{bake_recipes()}.
}
\examples{
# Basic recipe without steps
r <- recipe(
  name = "Basic ECH Indicators",
  user = "Analyst",
  svy = survey_empty(type = "ech", edition = "2023"),
  description = "Basic labor indicators for ECH 2023"
)
r

\donttest{
# Recipe with steps using local data
dt <- data.table::data.table(
  id = 1:50, age = sample(18:65, 50, TRUE),
  income = runif(50, 1000, 5000), w = runif(50, 0.5, 2)
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "demo",
  psu = NULL, engine = "data.table",
  weight = add_weight(annual = "w")
)
svy <- svy |>
  step_compute(income_cat = ifelse(income > 3000, "high", "low")) |>
  step_recode(age_group, age < 30 ~ "young", .default = "adult")
r2 <- recipe(
  name = "Demo", user = "test", svy = svy,
  description = "Demo recipe", steps = get_steps(svy)
)
r2
}

}
\seealso{
\code{\link{Recipe}} for class definition
\code{\link{save_recipe}} to save recipes
\code{\link{read_recipe}} to load recipes
\code{\link{get_recipe}} to retrieve recipes from repository
\code{\link{bake_recipes}} to apply recipes to data

Other recipes: 
\code{\link{Recipe-class}},
\code{\link{add_recipe}()},
\code{\link{bake_recipes}()},
\code{\link{explore_recipes}()},
\code{\link{get_recipe}()},
\code{\link{print.Recipe}()},
\code{\link{publish_recipe}()},
\code{\link{read_recipe}()},
\code{\link{save_recipe}()},
\code{\link{steps_to_recipe}()}
}
\concept{recipes}
\keyword{recipe}
