% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_tidy_api.R
\name{rank_workflows}
\alias{rank_workflows}
\title{Rank workflows by downloads}
\usage{
rank_workflows(n = NULL)
}
\arguments{
\item{n}{Integer or \code{NULL} (default \code{NULL}). Maximum number to return,
or \code{NULL} for all.}
}
\value{
List of RecipeWorkflow objects sorted by downloads.
}
\description{
Get the top workflows ranked by download count.
}
\examples{
set_workflow_backend("local", path = tempfile(fileext = ".json"))
top5 <- rank_workflows(n = 5)
length(top5)

}
\seealso{
\code{\link{search_workflows}}, \code{\link{filter_workflows}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{filter_workflows}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{search_workflows}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
