% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recipes.R
\name{publish_recipe}
\alias{publish_recipe}
\title{Publish Recipe}
\usage{
publish_recipe(recipe)
}
\arguments{
\item{recipe}{A Recipe object.}
}
\value{
The Recipe object (invisibly).
}
\description{
Publishes a Recipe object to the active backend
(local JSON registry or remote API).
}
\examples{
set_backend("local", path = tempfile(fileext = ".json"))
r <- recipe(
  name = "Example", user = "Test",
  svy = survey_empty(type = "ech", edition = "2023"),
  description = "Example recipe"
)
publish_recipe(r)
length(list_recipes())
}
\seealso{
Other recipes: 
\code{\link{Recipe-class}},
\code{\link{add_recipe}()},
\code{\link{bake_recipes}()},
\code{\link{explore_recipes}()},
\code{\link{get_recipe}()},
\code{\link{print.Recipe}()},
\code{\link{read_recipe}()},
\code{\link{recipe}()},
\code{\link{save_recipe}()},
\code{\link{steps_to_recipe}()}
}
\concept{recipes}
\keyword{utils}
