% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelSurvey.R
\name{get_follow_up}
\alias{get_follow_up}
\title{Get follow-up surveys from a rotating panel}
\usage{
get_follow_up(
  RotativePanelSurvey,
  index = seq_along(RotativePanelSurvey$follow_up)
)
}
\arguments{
\item{RotativePanelSurvey}{A \code{RotativePanelSurvey} object from which
to extract the follow-up surveys}

\item{index}{Integer vector specifying which follow-up surveys to extract.
Defaults to all available (1:length(follow_up)). Can be a single index
or a vector of indices}
}
\value{
A list of \code{Survey} objects corresponding to the specified
follow-up surveys. If a single index is specified, returns a list with
one element
}
\description{
Extracts one or more follow-up surveys (waves after the implantation) from
a RotativePanelSurvey object. Follow-up surveys represent subsequent data
collections and are essential for longitudinal and temporal change analysis.
}
\details{
Follow-up surveys are fundamental in rotating panels because:
\itemize{
\item Enable longitudinal analysis: Track the same units over time
\item Capture temporal changes: Evolution of economic, social, and
demographic variables
\item Maintain representativeness: Each wave preserves population
representativeness through controlled rotation
\item Optimize resources: Reuse information from previous waves to
reduce collection costs
\item Facilitate comparisons: Consistent temporal structure for
trend analysis
}

In rotating panels like ECH:
\itemize{
\item Each follow-up wave covers a specific period (monthly/quarterly)
\item Units rotate gradually maintaining temporal overlap
\item Indices correspond to the chronological collection order
\item Each follow-up maintains methodological consistency with implantation
}
}
\examples{
impl <- Survey$new(
  data = data.table::data.table(id = 1:5, w = 1),
  edition = "2023", type = "test", psu = NULL,
  engine = "data.table", weight = add_weight(annual = "w")
)
fu1 <- Survey$new(
  data = data.table::data.table(id = 1:5, w = 1),
  edition = "2023_01", type = "test", psu = NULL,
  engine = "data.table", weight = add_weight(annual = "w")
)
fu2 <- Survey$new(
  data = data.table::data.table(id = 1:5, w = 1),
  edition = "2023_02", type = "test", psu = NULL,
  engine = "data.table", weight = add_weight(annual = "w")
)
panel <- RotativePanelSurvey$new(
  implantation = impl, follow_up = list(fu1, fu2),
  type = "test", default_engine = "data.table",
  steps = list(), recipes = list(), workflows = list(), design = NULL
)
get_follow_up(panel, index = 1)
get_follow_up(panel)

}
\seealso{
\code{\link{get_implantation}} for obtaining the implantation survey
\code{\link{extract_surveys}} for extracting surveys by temporal criteria
\code{\link{load_panel_survey}} for loading rotating panels
\code{\link{workflow}} for analysis with follow-up surveys

Other panel-surveys: 
\code{\link{PoolSurvey}},
\code{\link{RotativePanelSurvey}},
\code{\link{extract_surveys}()},
\code{\link{get_implantation}()}
}
\concept{panel-surveys}
\keyword{panel-survey}
