% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_tidy_api.R
\name{filter_recipes}
\alias{filter_recipes}
\title{Filter recipes by criteria}
\usage{
filter_recipes(
  survey_type = NULL,
  edition = NULL,
  category = NULL,
  certification_level = NULL
)
}
\arguments{
\item{survey_type}{Character survey type or NULL.}

\item{edition}{Character edition or NULL.}

\item{category}{Character category name or NULL.}

\item{certification_level}{Character certification level or NULL.}
}
\value{
List of matching Recipe objects.
}
\description{
Filter recipes in the active backend by survey type, edition, category,
or certification level.
}
\examples{
set_backend("local", path = tempfile(fileext = ".json"))
ech_recipes <- filter_recipes(survey_type = "ech")
length(ech_recipes)

}
\seealso{
\code{\link{search_recipes}}, \code{\link{rank_recipes}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_workflows}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{search_workflows}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
