% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{cat_design_type}
\alias{cat_design_type}
\title{cat_design_type}
\usage{
cat_design_type(self, design_name)
}
\arguments{
\item{self}{Object of class Survey}

\item{design_name}{Name of design}
}
\value{
Character string describing the design type, or "None".
}
\description{
Cast design type from survey
}
\examples{
\donttest{
dt <- data.table::data.table(id = 1:20, x = rnorm(20), w = runif(20, 0.5, 2))
svy <- Survey$new(
  data = dt, edition = "2023", type = "demo",
  psu = NULL, engine = "data.table",
  weight = add_weight(annual = "w")
)
svy$ensure_design()
cat_design_type(svy, "annual")
}
}
\seealso{
Other survey-objects: 
\code{\link{Survey}},
\code{\link{cat_design}()},
\code{\link{get_data}()},
\code{\link{get_metadata}()},
\code{\link{has_design}()},
\code{\link{has_recipes}()},
\code{\link{has_steps}()},
\code{\link{is_baked}()},
\code{\link{set_data}()},
\code{\link{survey_empty}()},
\code{\link{survey_to_data_frame}()},
\code{\link{survey_to_datatable}()},
\code{\link{survey_to_tibble}()}
}
\concept{survey-objects}
\keyword{survey}
