% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_client.R
\name{api_list_recipes}
\alias{api_list_recipes}
\title{List recipes from API}
\usage{
api_list_recipes(
  search = NULL,
  survey_type = NULL,
  topic = NULL,
  certification = NULL,
  user = NULL,
  limit = 50,
  offset = 0
)
}
\arguments{
\item{search}{Text search (matches name/description)}

\item{survey_type}{Filter by survey type (e.g., \code{"ech"})}

\item{topic}{Filter by topic}

\item{certification}{Filter by certification level}

\item{user}{Filter by author email}

\item{limit}{Maximum results (default 50)}

\item{offset}{Skip first N results (default 0)}
}
\value{
List of Recipe objects
}
\description{
Fetch recipes with optional search and filters.
}
\examples{
\dontrun{
configure_api("https://metasurvey-api.example.com")
recipes <- api_list_recipes(survey_type = "ech")
}
}
\seealso{
Other api-recipes: 
\code{\link{api_get_recipe}()},
\code{\link{api_get_recipe_dependents}()},
\code{\link{api_publish_recipe}()}
}
\concept{api-recipes}
