% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{add_recipe}
\alias{add_recipe}
\title{Add a recipe to a Survey}
\usage{
add_recipe(svy, recipe, bake = lazy_default())
}
\arguments{
\item{svy}{Survey object}

\item{recipe}{A Recipe object}

\item{bake}{Logical; whether to bake immediately (default: lazy_default())}
}
\value{
The Survey object (invisibly), modified in place
}
\description{
Tidy wrapper for \code{svy$add_recipe(recipe)}.
}
\examples{
svy <- survey_empty(type = "ech", edition = "2023")
r <- recipe(
  name = "Example", user = "test",
  svy = svy, description = "Example"
)
svy <- add_recipe(svy, r)
}
\seealso{
Other recipes: 
\code{\link{Recipe-class}},
\code{\link{bake_recipes}()},
\code{\link{explore_recipes}()},
\code{\link{get_recipe}()},
\code{\link{print.Recipe}()},
\code{\link{publish_recipe}()},
\code{\link{read_recipe}()},
\code{\link{recipe}()},
\code{\link{save_recipe}()},
\code{\link{steps_to_recipe}()}
}
\concept{recipes}
