% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tree.R
\name{read_tree}
\alias{read_tree}
\title{Evaluate utilities}
\usage{
read_tree(file, skip, nrows)
}
\arguments{
\item{file}{input csv file containing the tree.}

\item{skip}{starting row for read.}

\item{nrows}{number of rows to read.}
}
\value{
data.table with utilities.
}
\description{
Read a csv file where the decision tree is defined.
}
\examples{
library( data.table )
library( igraph )
file <- system.file("extdata", "tree.csv", package = "mau" )
sheetIndex <- 1
tree.data <- read_tree( file, skip = 0, nrows = 8 )
}
\seealso{
\code{\link{read_utilities}}, \code{\link{make_decision_tree}}
}
\author{
Pedro Guarderas, Andrés Lopez
}
