% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmer.R
\name{lmer.display}
\alias{lmer.display}
\title{lmer.display: table for "lmerMod" or "glmerMod" object (lme4 package)}
\usage{
lmer.display(
  lmerMod.obj,
  dec = 2,
  ci.ranef = F,
  pcut.univariate = NULL,
  data_for_univariate = NULL
)
}
\arguments{
\item{lmerMod.obj}{"lmerMod" or "glmerMod" object}

\item{dec}{Decimal, Default: 2}

\item{ci.ranef}{Show confidence interval of random effects?, Default: F}

\item{pcut.univariate}{pcut.univariate, Default: NULL}

\item{data_for_univariate}{data for univariate model, Default: NULL}
}
\value{
Table: fixed & random effect
}
\description{
Make mixed effect model results from "lmerMod" or "glmerMod" object (lme4 package)
}
\details{
DETAILS
}
\examples{
library(geepack)
data(dietox)
dietox$Cu <- as.factor(dietox$Cu)
l1 <- lme4::lmer(Weight ~ Time + Cu + (1 | Pig) + (1 | Evit), data = dietox)
lmer.display(l1)
}
