% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_clu_relationship}
\alias{assert_clu_relationship}
\title{Assert CLU relationships}
\usage{
assert_clu_relationship(central, lower, upper)
}
\arguments{
\item{central}{[num] vector of central values}

\item{lower}{[num] vector of lower bound values}

\item{upper}{[num] vector of upper bound values}
}
\value{
[none] stop if any of the CLU relationships are violated
}
\description{
Validates that the relationships between central, lower, and upper values
are consistent with CLU (Central, Lower, Upper) conventions:
- upper >= central
- central >= lower
- upper >= lower
}
\seealso{
Other assertions: 
\code{\link{assert_fround_return_schema}()},
\code{\link{assert_metric}()},
\code{\link{assert_rate_unit}()},
\code{\link{assert_set_choice}()},
\code{\link{assert_style_schema}()},
\code{\link{assert_x_gte_y}()},
\code{\link{assert_x_in_y}()},
\code{\link{assert_x_not_in_y}()}
}
\concept{assertions}
\keyword{internal}
