% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventBaseflow.R
\name{eventBaseflow}
\alias{eventBaseflow}
\title{Event identification (using baseflow index)}
\usage{
eventBaseflow(
  data,
  BFI_Th = 0.5,
  bfi = baseflowB(data)$bfi,
  min.length = 1,
  out.style = "summary"
)
}
\arguments{
\item{data}{The data vector (e.g. a streamflow time series)}

\item{BFI_Th}{Minimum BFI to identify baseflow}

\item{bfi}{If no BFI is provided the BFI is calculated automatically using baseflowB}

\item{min.length}{Minimum length for an event}

\item{out.style}{The type of output (currently either "summary" or "none")}
}
\value{
By default, the \code{out.style} returns the indices of the maximum in each event, as well as the value of
the maximum and the sum of the \code{data} in each event, alongside the start and end of the events. Otherwise just
the indices of start and end of events as a two column dataframe are returned.
}
\description{
Events are identified on the basis of the Baseflow Index (BFI).
}
\details{
Any flow associated with a BFI below \code{BFI_Th} will be considered an event with a minimum length \code{min.length}.
}
\examples{
# Example
BFI_res = eventBaseflow(dataBassRiver, BFI_Th = 0.5, min.length = 1)
}
\references{
  Wasko, C. & Guo, D. (2022) Understanding event runoff coefficient variability across Australia using the hydroEvents R package. Hydrological Processes <doi:10.1002/hyp.14563>.
}
\seealso{
\code{\link{calcStats}} \code{\link{eventBaseflow}} \code{\link{eventMaxima}} \code{\link{eventPOT}}
}
\keyword{events}
