% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickands_estimator.R
\name{pickands_estimator}
\alias{pickands_estimator}
\title{Pickands Estimator}
\usage{
pickands_estimator(data, k, na.rm = FALSE)
}
\arguments{
\item{data}{A numeric vector of i.i.d. observations.}

\item{k}{An integer specifying the number of top order statistics to use
(the size of the tail). Must be strictly less than the sample size.}

\item{na.rm}{Logical. If \code{TRUE}, missing values (\code{NA}) are removed
before analysis. Defaults to \code{FALSE}.}
}
\value{
A single numeric scalar: Pickands estimator calculation of the shape parameter \eqn{\xi}.
}
\description{
Pickands estimator to calculate \eqn{\xi} for the input data.
}
\details{
\deqn{\hat{\xi}_{P}  = \frac{1}{\log 2} \log ( \frac{X_{(k)} - X_{(2k)}}{X_{(2k)} - X_{(4k)}})}
}
\examples{

xmin <- 1
alpha <- 2
r <- runif(800, 0, 1)
x <- (xmin * r^(-1/(alpha)))
pickands <- pickands_estimator(data = x, k = 5)

}
\references{
Pickands, J. (1975). Statistical Inference Using Extreme Order Statistics. \emph{The Annals of Statistics}, \bold{3}(1), 119–131. \url{http://www.jstor.org/stable/2958083}

Nair, J., Wierman, A., & Zwart, B. (2022). \emph{The Fundamentals of Heavy Tails: Properties, Emergence, and Estimation}. Cambridge University Press. (pp. 219-221) \doi{10.1017/9781009053730}
}
