% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{setMean}
\alias{setMean}
\title{Set the mean for the target MTN}
\usage{
setMean(engine, mean)
}
\arguments{
\item{engine}{A Zigzag-HMC engine container object.}

\item{mean}{the mean vector.}
}
\description{
Set the mean vector for a given Zigzag-HMC engine object.
}
\examples{
# First create an engine
engine <- createEngine(dimension = 2, 
                       lowerBounds = c(-1, -1),
                       upperBounds = c(1, 1),
                       seed = 123,
                       mean = c(0, 0),
                       precision = diag(2))
# Update the mean
setMean(engine, mean = c(0.5, 0.5))
}
\seealso{
\code{\link[=createEngine]{createEngine()}}, \code{\link[=createNutsEngine]{createNutsEngine()}}
}
