% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_location_info.R
\name{get_location_info}
\alias{get_location_info}
\title{Retrieve additional information for wms layer}
\usage{
get_location_info(x,
                  apikey = "ortho",
                  layer = "ORTHOIMAGERY.ORTHOPHOTOS",
                  read_sf = TRUE,
                  version = "1.3.0")
}
\arguments{
\item{x}{Object of class \code{sf} or \code{sfc}. Only single point are supported for now.
Needs to be located in France.}

\item{apikey}{\code{character}; API key from get_apikeys() or directly from the IGN website}

\item{layer}{\code{character}; layer name obtained from
\code{get_layers_metadata("wms-r")} or the
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}.}

\item{read_sf}{\code{logical}; if \code{TRUE} an \code{sf} object is returned but
response times may be higher.}

\item{version}{\code{character}; old param}
}
\value{
\code{character} or \code{sf} containing additional information about the layer
}
\description{
For some wms layer more information can be found with GetFeatureInfo request.
This function first check if info are available. If not, available layers
are returned.
}
\examples{
\dontrun{
library(sf)
library(tmap)

# From single point
x <- st_centroid(read_sf(system.file("extdata/penmarch.shp", package = "happign")))
location_info <- get_location_info(x, "ortho", "ORTHOIMAGERY.ORTHOPHOTOS", read_sf = F)
location_info$date_vol

# From multiple point
x1 <- st_sfc(st_point(c(-3.549957, 47.83396)), crs = 4326) # Carnoet forest
x2 <- st_sfc(st_point(c(-3.745995, 47.99296)), crs = 4326) # Coatloch forest

forests <- lapply(list(x1, x2),
                  get_location_info,
                  apikey = "environnement",
                  layer = "FORETS.PUBLIQUES",
                  read_sf = T)

qtm(forests[[1]]) + qtm(forests[[2]])

# Find all queryable layers
queryable_layers <- lapply(get_apikeys(), are_queryable) |> unlist()
}
}
