% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_data_by_date.R
\name{cut_data_by_date}
\alias{cut_data_by_date}
\alias{cut_data_by_date.default}
\alias{cut_data_by_date.nb_sim_data}
\alias{cut_data_by_date.nb_sim_seasonal}
\title{Cut simulated trial data at a calendar date}
\usage{
cut_data_by_date(data, cut_date, event_gap = 0, ...)

\method{cut_data_by_date}{default}(data, cut_date, event_gap = 0, ...)

\method{cut_data_by_date}{nb_sim_data}(data, cut_date, event_gap = 0, ...)

\method{cut_data_by_date}{nb_sim_seasonal}(data, cut_date, event_gap = 0, ...)
}
\arguments{
\item{data}{Data generated by \code{\link[=nb_sim]{nb_sim()}}.}

\item{cut_date}{Calendar time (relative to trial start) at which to censor follow-up.}

\item{event_gap}{Gap duration after each event during which no new events are counted.
Can be a numeric value (default \code{0}) or a function returning a numeric value.
The time at risk is reduced by the sum of these gaps (truncated by the cut date).}

\item{...}{Additional arguments passed to methods.}
}
\value{
A data frame with one row per subject randomized prior to \code{cut_date} containing:
\describe{
\item{id}{Subject identifier}
\item{treatment}{Treatment group}
\item{enroll_time}{Time of enrollment relative to trial start}
\item{tte}{Time at risk (total follow-up minus event gap periods)}
\item{tte_total}{Total follow-up time (calendar time, not adjusted for gaps)}
\item{events}{Number of observed events}
}

A data frame with one row per subject randomized prior to \code{cut_date}.
This method stops with an error for unsupported classes.

A data frame with one row per subject randomized prior to \code{cut_date}.
Includes total events and follow-up time within the cut window.

A data frame with one row per subject randomized prior to \code{cut_date}.
Includes season and follow-up time within the cut window.
}
\description{
Censors follow-up at a specified calendar time and aggregates events per subject.
Returns one row per subject randomized before the cut date, with the total
number of observed events and follow-up times.
}
\section{Methods (by class)}{
\itemize{
\item \code{cut_data_by_date(default)}: Default method.

\item \code{cut_data_by_date(nb_sim_data)}: Method for \code{nb_sim} data.

\item \code{cut_data_by_date(nb_sim_seasonal)}: Method for \code{nb_sim_seasonal} data.

}}
\examples{
enroll_rate <- data.frame(rate = 20 / (5 / 12), duration = 5 / 12)
fail_rate <- data.frame(treatment = c("Control", "Experimental"), rate = c(0.5, 0.3))
dropout_rate <- data.frame(
  treatment = c("Control", "Experimental"),
  rate = c(0.1, 0.05), duration = c(100, 100)
)
sim <- nb_sim(enroll_rate, fail_rate, dropout_rate, max_followup = 2, n = 20)
cut_data_by_date(sim, cut_date = 1)
}
