% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-brain.R
\name{theme_brain}
\alias{theme_brain}
\alias{theme_darkbrain}
\alias{theme_custombrain}
\alias{theme_brain2}
\title{Themes for brain atlas plots}
\usage{
theme_brain(text.size = 12, text.family = "mono")

theme_darkbrain(text.size = 12, text.family = "mono")

theme_custombrain(
  plot.background = "white",
  text.colour = "darkgrey",
  text.size = 12,
  text.family = "mono"
)

theme_brain2(
  plot.background = "white",
  text.colour = "darkgrey",
  text.size = 12,
  text.family = "mono"
)
}
\arguments{
\item{text.size}{Text size in points (default: `12`).}

\item{text.family}{Font family (default: `"mono"`).}

\item{plot.background}{Background fill colour (`theme_custombrain` and
`theme_brain2` only).}

\item{text.colour}{Text colour (`theme_custombrain` and `theme_brain2` only).}
}
\value{
A [ggplot2::theme] object.
}
\description{
A set of ggplot2 themes designed for brain atlas visualisations. All themes
remove axis ticks and grid lines for a clean presentation.
}
\details{
\describe{

\item{`theme_brain`}{
Default theme. Transparent background, no axes, no grid.}

\item{`theme_darkbrain`}{
Dark theme with black background and light text.}

\item{`theme_custombrain`}{
Fully customisable background, text colour, size, and font.}

\item{`theme_brain2`}{
Like `theme_custombrain` but with axis text removed entirely.}

}
}
\examples{
library(ggplot2)

p <- ggplot() +
  geom_brain(atlas = dk())

p +
  theme_brain()

p +
  theme_darkbrain()

}
\seealso{
[geom_brain()], [ggplot2::theme()]
}
