% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additions.R
\name{set_positioning}
\alias{set_positioning}
\title{Set hemisphere positioning mode}
\usage{
set_positioning(p, positioning = c("anatomical", "centered"))
}
\arguments{
\item{p}{ggseg3d widget object}

\item{positioning}{How to position hemispheres:
- "anatomical": Offset so medial surfaces are adjacent at midline.
  Left at negative x, right at positive x. Best for displaying both
  hemispheres together.
- "centered": Center each hemisphere at the origin. Best for
  single-hemisphere snapshots where consistent sizing is needed.}
}
\value{
ggseg3d widget object with repositioned meshes
}
\description{
Repositions meshes in a ggseg3d widget to either anatomical or centered mode.
This modifies the x-coordinates of all meshes in the widget.
}
\examples{
\dontrun{
# View both hemispheres anatomically positioned
ggseg3d(hemisphere = c("left", "right")) |>
  set_positioning("anatomical") |>
  pan_camera("left lateral")

# Atlas creation: centered (default) for consistent sizing
ggseg3d(hemisphere = "left") |>
  set_orthographic() |>
  pan_camera("left lateral") |>
  snapshot_brain("left_lateral.png")
}
}
