% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{ggml_schedule_reduce_on_plateau}
\alias{ggml_schedule_reduce_on_plateau}
\title{Reduce on plateau LR scheduler}
\usage{
ggml_schedule_reduce_on_plateau(
  monitor = "val_loss",
  factor = 0.5,
  patience = 5,
  min_lr = 1e-07,
  min_delta = 1e-04,
  mode = "auto"
)
}
\arguments{
\item{monitor}{Metric to monitor: "val_loss", "train_loss", etc.}

\item{factor}{Factor to reduce LR by}

\item{patience}{Epochs with no improvement before reducing}

\item{min_lr}{Minimum LR}

\item{min_delta}{Minimum change to qualify as improvement}

\item{mode}{"min" or "max". "auto" infers from monitor name.}
}
\value{
List with on_epoch_end function
}
\description{
Reduces LR when a metric stops improving.
}
\seealso{
Other callbacks: 
\code{\link{ggml_callback_early_stopping}()},
\code{\link{ggml_schedule_cosine_decay}()},
\code{\link{ggml_schedule_step_decay}()}
}
\concept{callbacks}
