% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_reshape_1d}
\alias{ggml_reshape_1d}
\title{Reshape to 1D (Graph)}
\usage{
ggml_reshape_1d(ctx, a, ne0)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}

\item{ne0}{Size of dimension 0}
}
\value{
Reshaped tensor
}
\description{
Reshapes tensor to 1D with ne0 elements
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 3, 4)
ggml_set_f32(a, 1:12)
result <- ggml_reshape_1d(ctx, a, 12)
ggml_free(ctx)
}
}
