% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensors.R
\name{ggml_new_f32}
\alias{ggml_new_f32}
\title{Create Scalar F32 Tensor}
\usage{
ggml_new_f32(ctx, value)
}
\arguments{
\item{ctx}{GGML context}

\item{value}{Numeric value}
}
\value{
Tensor pointer (1-element F32 tensor)
}
\description{
Creates a 1-element tensor containing a single float value.
Useful for scalar operations, learning rates, and other scalar floats.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
scalar <- ggml_new_f32(ctx, 3.14)
ggml_get_f32(scalar)
ggml_free(ctx)
}
}
