% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_layers.R
\name{ggml_layer_embedding}
\alias{ggml_layer_embedding}
\title{Add Embedding Layer}
\usage{
ggml_layer_embedding(model, vocab_size, dim, name = NULL, trainable = TRUE)
}
\arguments{
\item{model}{A \code{ggml_sequential_model} or \code{ggml_tensor_node}.}

\item{vocab_size}{Number of distinct tokens (vocabulary size).}

\item{dim}{Embedding dimension (vector length per token).}

\item{name}{Optional layer name.}

\item{trainable}{Logical; whether embedding weights are updated during training.}
}
\value{
The model with the embedding layer appended, or a new tensor node.
}
\description{
Looks up dense vectors for integer token indices.  The input must be an
integer matrix of 0-based indices in \code{[0, vocab_size - 1]} (use
\code{ggml_input(shape, dtype = "int32")} in Functional mode).
}
\section{Axis order (ggml vs Keras)}{

ggml stores tensors in column-major order, so the output shape is
\code{[dim, seq_len]} per sample (ggml convention) rather than
\code{[seq_len, dim]} as in Keras.  When you call \code{ggml_layer_flatten()}
after embedding the result is the same flattened vector regardless of order,
but if you access raw output tensors be aware of this transposition.
}

\section{Index validation}{

Indices must be in \code{[0, vocab_size - 1]}.  Out-of-range values cause
undefined behaviour inside the ggml kernel (no bounds check is performed at
the R level).
}

\examples{
\donttest{
inp <- ggml_input(shape = 10L, dtype = "int32")
out <- inp |>
  ggml_layer_embedding(vocab_size = 1000L, dim = 32L) |>
  ggml_layer_flatten() |>
  ggml_layer_dense(10L, activation = "softmax")
model <- ggml_model(inputs = inp, outputs = out)
}
}
