% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autograd.R
\name{backward}
\alias{backward}
\title{Run backward pass from a scalar loss tensor}
\usage{
backward(loss)
}
\arguments{
\item{loss}{Scalar ag_tensor}
}
\value{
Named environment: tensor id -> gradient matrix (for use by optimizer$step)
}
\description{
Traverses the gradient tape in reverse and accumulates gradients into
\code{tensor$grad} for all leaf tensors with \code{requires_grad = TRUE}.
}
\examples{
\donttest{
w <- ag_param(matrix(runif(4), 2, 2))
x <- ag_tensor(matrix(c(1, 2), 2, 1))
y <- ag_tensor(matrix(c(0, 1), 2, 1))
with_grad_tape({
  out  <- ag_matmul(w, x)
  loss <- ag_mse_loss(out, y)
})
grads <- backward(loss)
}
}
