% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_order.R
\name{legend_order}
\alias{legend_order}
\title{Reorder Legend Entries}
\usage{
legend_order(order, aesthetic = "colour")
}
\arguments{
\item{order}{A character vector specifying the desired order of legend entries,
or a function to apply to the current order (e.g., \code{rev}, \code{sort}).}

\item{aesthetic}{Character string specifying which aesthetic's legend to reorder.
Default is \code{"colour"}. Common values: \code{"colour"}, \code{"color"}, \code{"fill"},
\code{"shape"}, \code{"linetype"}, \code{"size"}, \code{"alpha"}.}
}
\value{
A ggplot2 scale object that reorders the legend.
}
\description{
Change the order of legend entries without modifying factor levels in your data.
This provides a simpler alternative to manually setting factor levels or using
the \code{breaks} argument in scale functions.
}
\details{
This function works by setting the \code{breaks} argument of the appropriate
discrete scale. It automatically detects whether to use \code{scale_colour_discrete},
\code{scale_fill_discrete}, etc. based on the \code{aesthetic} argument.

When \code{order} is a function (like \code{rev} or \code{sort}), it will be applied to
the default order of legend entries.
}
\examples{
library(ggplot2)

p <- ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point(size = 3)

# Specify exact order
p + legend_order(c("8", "6", "4"))

# Reverse the order
p + legend_order(rev)

# Sort alphabetically/numerically
p + legend_order(sort)

# Reorder fill aesthetic
ggplot(mtcars, aes(factor(cyl), fill = factor(cyl))) +
  geom_bar() +
  legend_order(c("8", "4", "6"), aesthetic = "fill")

}
\seealso{
\code{\link{legend_reverse}} for a simpler way to reverse legend order,
\code{\link{legend_style}} for styling legend appearance.
}
