% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcc.R
\name{lcc_fwd}
\alias{lcc_fwd}
\alias{lcc_rev}
\title{Lambert Conformal Conic projection}
\usage{
lcc_fwd(
  x,
  lon0,
  lat0 = NULL,
  stdlat = NULL,
  stdlat1 = NULL,
  stdlat2 = NULL,
  k0 = 1,
  k1 = 1
)

lcc_rev(
  x,
  y,
  lon0,
  lat0 = NULL,
  stdlat = NULL,
  stdlat1 = NULL,
  stdlat2 = NULL,
  k0 = 1,
  k1 = 1
)
}
\arguments{
\item{x}{For forward conversion: a two-column matrix or data frame of
coordinates (longitude, latitude) in decimal degrees, or a list with
longitude and latitude components. Can also be a length-2 numeric vector
for a single point.
For reverse conversion: numeric vector of easting values (x coordinates)
in meters.}

\item{lon0}{Central meridian (longitude of origin) in decimal degrees.}

\item{lat0}{Latitude of origin in decimal degrees (used for documentation,
not in the projection calculation itself).}

\item{stdlat}{Standard parallel in decimal degrees for single standard
parallel (tangent cone) projections.}

\item{stdlat1, stdlat2}{First and second standard parallels in decimal degrees
for two standard parallel (secant cone) projections.}

\item{k0}{Scale factor at the standard parallel. Default is 1.}

\item{k1}{Scale factor at the first standard parallel for two standard
parallel projections. Default is 1.}

\item{y}{Numeric vector of northing values (y coordinates) in meters for
reverse conversion.}
}
\value{
Data frame with columns:
\itemize{
\item For forward conversion:
\itemize{
\item \code{x}: Easting in meters
\item \code{y}: Northing in meters
\item \code{convergence}: Meridian convergence in degrees
\item \code{scale}: Scale factor at the point
\item \code{lon}: Longitude (echoed from input)
\item \code{lat}: Latitude (echoed from input)
}
\item For reverse conversion:
\itemize{
\item \code{lon}: Longitude in decimal degrees
\item \code{lat}: Latitude in decimal degrees
\item \code{convergence}: Meridian convergence in degrees
\item \code{scale}: Scale factor at the point
\item \code{x}: Easting (echoed from input)
\item \code{y}: Northing (echoed from input)
}
}
}
\description{
Convert geographic coordinates (longitude/latitude) to Lambert Conformal
Conic (LCC) projected coordinates, or convert projected coordinates back
to geographic coordinates.
}
\details{
The Lambert Conformal Conic projection is a conic map projection commonly
used for aeronautical charts, state plane coordinate systems, and many
national/regional coordinate systems.

Two forms are supported:
\itemize{
\item \strong{Single standard parallel} (tangent cone): The cone is tangent to the
ellipsoid at one latitude. Use \code{lcc_fwd()} and \code{lcc_rev()} with \code{stdlat}.
\item \strong{Two standard parallels} (secant cone): The cone intersects the ellipsoid
at two latitudes. Use \code{lcc_fwd()} and \code{lcc_rev()} with \code{stdlat1} and
\code{stdlat2}.
}

The projection is conformal (preserves local angles/shapes) and is best
suited for mid-latitude regions with greater east-west extent.

All functions use the WGS84 ellipsoid and are fully vectorized on
coordinate inputs.
}
\examples{
# Single standard parallel (e.g., for a state plane zone)
pts <- cbind(lon = c(-100, -99, -98), lat = c(40, 41, 42))
lcc_fwd(pts, lon0 = -100, stdlat = 40)

# Two standard parallels (e.g., for continental US)
# CONUS Albers-like setup
lcc_fwd(pts, lon0 = -96, stdlat1 = 33, stdlat2 = 45)

# Round-trip conversion
fwd <- lcc_fwd(pts, lon0 = -100, stdlat = 40)
lcc_rev(fwd$x, fwd$y, lon0 = -100, stdlat = 40)
}
\seealso{
\code{\link[=utmups_fwd]{utmups_fwd()}} for UTM/UPS projections which are also conformal.
}
