% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imls_to_arr.R
\name{imls_to_arr}
\alias{imls_to_arr}
\title{convert a list of im objects to a three-dimensional array}
\usage{
imls_to_arr(imls, start = 1, end = NULL, entire_window = NULL, ...)
}
\arguments{
\item{imls}{a list of im objects (imlist)}

\item{start}{the index of the first im to be converted. Default is 1.}

\item{end}{the index of the last im to be converted. If not provided, then it will be set to the length of the list.}

\item{entire_window}{a owin object. If given, then the values outside the region will be set to `NA`.}

\item{...}{Additional arguments passed to spatstat conversion functions.}
}
\description{
`imls_to_arr()` convert a list of im object to a 3D array
}
\details{
`imls_to_arr()` is a internal function for `imls_to_vec()`. By default, it returns a three-dimensional array of dimension \eqn{n} by \eqn{m} by\eqn{l} where \eqn{n} and \eqn{m}
are the dimensions of the im objects, and \eqn{l} is the length of the list. All the im objects in the list need to have the same dimensions.
}
