% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dx_supthin.R
\name{dx_supthin}
\alias{dx_supthin}
\title{Perform superthinning tests}
\usage{
dx_supthin(
  hfr,
  dep_var,
  indep_var,
  window,
  rescale = 1,
  max_r = 50,
  n_sample = 1000,
  nsim = 1000,
  unit = "km"
)
}
\arguments{
\item{hfr}{hyperframe}

\item{dep_var}{The name of the dependent variable.
Since we need to obtain the observed density of treatment events,
`dep_var` should be the name of the treatment variable.}

\item{indep_var}{vector of names of independent variables (covariates)}

\item{window}{owin object}

\item{rescale}{conversion as needed (namely when the unit of distance of the owin object is in meters).
By default = 1 (no conversion)}

\item{max_r}{max distance in which the envelope tests are performed}

\item{n_sample}{the number of points to sample. by default = 1000, if the number of points are smaller than this, no sampling is performed}

\item{nsim}{the number of simulations to perform for the envelope tests}

\item{unit}{distance units after conversion. By default "km"}
}
\value{
A list of resulting dataframe (`result_data`), windows (`window_list`), data for distance quantiles,
and a window object for the entire window
}
\description{
`dx_supthin()` performs superthinning tests to examine model validity.
}
