% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik_ce.R
\name{pmvn_ce}
\alias{pmvn_ce}
\title{Approximate Log-Likelihood via Continuous Extension (CE)}
\usage{
pmvn_ce(lower, upper, tau, od, c = 0.5, ret_llk = TRUE)
}
\arguments{
\item{lower}{Numeric vector of length \code{n}; lower bounds of the transformed latent variables.}

\item{upper}{Numeric vector of length \code{n}; upper bounds of the transformed latent variables.}

\item{tau}{Numeric vector of ARMA dependence parameters (concatenated \code{phi}, \code{theta}).}

\item{od}{Integer vector of length 2: \code{c(p, q)} for AR and MA orders.}

\item{c}{Smoothing bandwidth parameter; default is \code{0.5}. Must lie in (0,1).}

\item{ret_llk}{Logical; return log-likelihood if TRUE.}
}
\value{
Returns a numeric value representing the approximate log-likelihood.
}
\description{
Computes the approximate log-likelihood of a count time series model using the
Continuous Extension (CE) method. This approach approximates the probability
of the observed count vector by replacing the discrete indicator function with
a smooth approximation, controlled by a smoothing parameter \code{c}.
}
\details{
The method is applicable to Gaussian copula models with ARMA dependence and
arbitrary discrete marginal distributions, provided the marginal CDF bounds
are given for each observation.
}
\examples{
# Simulate Poisson AR(1) data
mu=10
tau=0.2
arma_order=c(1,0)
sim_data <- sim_poisson(mu =mu, tau=tau, arma_order=arma_order, nsim = 1000, seed = 1)
y <- sim_data$y

# Compute latent bounds for CE method
a <- qnorm(ppois(y - 1, lambda = mu))  # lower bound
b <- qnorm(ppois(y, lambda = mu))      # upper bound

# Approximate log-likelihood with CE method
llk_ce <- pmvn_ce(lower = a, upper = b, tau = tau, od = arma_order, c = 0.5)
print(llk_ce)

}
