% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfi.R
\name{cfi}
\alias{cfi}
\title{Calculate CFI for two correlation matrices}
\usage{
cfi(Sigma, Omega)
}
\arguments{
\item{Sigma}{(matrix) Population correlation or covariance matrix (with model
error).}

\item{Omega}{(matrix) Model-implied population correlation or covariance
matrix.}
}
\description{
Given two correlation matrices of the same dimension, calculate the CFI value
value using the independence model as the null model.
}
\examples{
library(fungible)

mod <- fungible::simFA(Model = list(NFac = 3),
                       Seed = 42)
set.seed(42)
Omega <- mod$Rpop
Sigma <- noisemaker(
  mod = mod,
  method = "CB",
  target_rmsea = 0.05
)$Sigma
cfi(Sigma, Omega)
}
