% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_project.R
\name{new}
\alias{new}
\title{Create a New Project (Master Wrapper)}
\usage{
new(
  name = NULL,
  location = NULL,
  type = "project",
  browse = interactive(),
  ...
)
}
\arguments{
\item{name}{Project name. If NULL (default), prompts interactively.}

\item{location}{Directory path where project will be created. If NULL (default),
prompts interactively.}

\item{type}{Project type. One of "project" (default), "project_sensitive",
"course", or "presentation".}

\item{browse}{Whether to open the project folder after creation (default: TRUE in
interactive sessions)}

\item{...}{Additional arguments passed to `project_}
}
\value{
Invisibly returns the result from \code{project_create()}
}
\description{
Flexible project creation interface. Alias for \code{new_project()} that accepts
type as a parameter.
}
\examples{
\donttest{
if (FALSE) {
# Create different project types
new("analysis", "~/projects/analysis")
new("study", "~/projects/study", type = "project_sensitive")
new("slides", "~/projects/slides", type = "presentation")
new("course-materials", "~/projects/course", type = "course")
}
}

}
\seealso{
\code{\link[=new_project]{new_project()}}, \code{\link[=new_project_sensitive]{new_project_sensitive()}}, \code{\link[=new_presentation]{new_presentation()}}, \code{\link[=new_course]{new_course()}}
}
