% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gui.R
\name{gui}
\alias{gui}
\title{Launch Framework GUI}
\usage{
gui(port = 8080, host = "127.0.0.1", browse = TRUE, route = NULL)
}
\arguments{
\item{port}{Port number to use (default: 8080)}

\item{host}{Host address to bind to. Default "127.0.0.1" for local access only.
Use "0.0.0.0" to allow connections from other machines (requires appropriate
network security).}

\item{browse}{Automatically open browser (default: TRUE)}

\item{route}{Initial route to open (default: NULL for home page)}
}
\value{
Invisibly returns the plumber server object
}
\description{
Opens a beautiful web-based interface for Framework with documentation,
project management, and settings configuration.
}
\examples{
\donttest{
if (FALSE) {
# Launch the GUI
framework::gui()

# Launch on specific port
framework::gui(port = 8888)

# Open directly to settings
framework::gui(route = "#/settings/basics")

# Run as standalone server (no browser, accessible from network)
framework::gui(port = 8080, host = "0.0.0.0", browse = FALSE)
}
}

}
\seealso{
\code{\link[=setup]{setup()}} for first-time configuration
}
