% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_poll}
\alias{send_poll}
\title{Send a poll}
\usage{
send_poll(client, number, name, values, selectable_count = 1L, verbose = FALSE)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Character. Recipient number with country code
(e.g., \code{"5581999990000"} or \code{"+5581999990000"}).}

\item{name}{Question text displayed in the poll.}

\item{values}{Character vector of poll options (minimum 2).}

\item{selectable_count}{Integer. Number of options a user can select
(default \code{1L} for single-choice).}

\item{verbose}{Logical. If \code{TRUE}, logs request/response details with
\strong{cli}.}
}
\value{
A named list with the API response. The HTTP status code is
stored in \code{attr(result, "http_status")}.
}
\description{
Sends a poll (question with selectable options) via
Evolution API v2.
}
\examples{
\dontrun{
send_poll(client, "5581999990000",
  name = "Favourite language?",
  values = c("R", "Python", "Julia"),
  selectable_count = 1)
}
}
