% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{jid}
\alias{jid}
\title{Build a WhatsApp JID from a raw phone number}
\usage{
jid(number)
}
\arguments{
\item{number}{Character scalar or vector. Raw phone number(s)
(e.g., \code{"+5581999990000"}).}
}
\value{
Character JID(s) (e.g., \code{"5581999990000@s.whatsapp.net"}).
}
\description{
Normalises a raw phone number by removing spaces, dashes,
parentheses, and the leading \code{+} sign, then appends
\verb{@s.whatsapp.net}.
}
\examples{
jid("+55 81 99999-0000")
#> "5581999990000@s.whatsapp.net"

jid("5581999990000")
#> "5581999990000@s.whatsapp.net"
}
