% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_evmissing.R
\name{evmissing_methods}
\alias{evmissing_methods}
\alias{coef.evmissing}
\alias{vcov.evmissing}
\alias{nobs.evmissing}
\alias{logLik.evmissing}
\alias{summary.evmissing}
\alias{print.summary.evmissing}
\alias{confint.evmissing}
\alias{plot.evmissing}
\title{Methods for objects of class \code{"evmissing"}}
\usage{
\method{coef}{evmissing}(object, ...)

\method{vcov}{evmissing}(object, ...)

\method{nobs}{evmissing}(object, ...)

\method{logLik}{evmissing}(object, ...)

\method{summary}{evmissing}(object, digits = max(3, getOption("digits") - 3L), ...)

\method{print}{summary.evmissing}(x, ...)

\method{confint}{evmissing}(
  object,
  parm = "all",
  level = 0.95,
  profile = FALSE,
  mult = 2,
  faster = FALSE,
  epsilon = 1e-04,
  ...
)

\method{plot}{evmissing}(
  x,
  adjust = TRUE,
  which = c("pp", "qq", "return", "density"),
  m = c(2, 10, 100, 1000),
  level = 0.95,
  profile = TRUE,
  num,
  npy = 1,
  ...
)
}
\arguments{
\item{object}{An object inheriting from class \code{"evmissing"}, a result of a
call to \code{\link{gev_mle}}.}

\item{...}{Further arguments. Only used in the following cases.
\itemize{
\item \code{plot.evmissing}: to pass graphical parameters to the graphical functions
\code{\link[graphics:plot.default]{plot}}, \code{\link[graphics:matplot]{matplot}},
\code{\link[graphics:abline]{abline}}, \code{\link[graphics:lines]{lines}},
\code{\link[graphics:matplot]{matlines}} and \code{\link[graphics:points]{points}}.
In particular, \code{col}, \code{lty} and \code{lwd} may be used to control the colour,
type and width of lines and \code{pch} the type of plotting symbol. All data
points are coloured black in all plots, which cannot be changed.
\item \code{print.summary.evmissing}: to pass arguments to \code{\link{print}}.
}}

\item{digits}{An integer. Passed to \code{\link{signif}} to round the
values in the summary.}

\item{x}{An object returned by \code{summary.evmissing}.}

\item{parm}{A character vector specifying the parameters for which
confidence intervals are to be calculated. The default, \code{which = "all"},
produces confidence intervals for all the parameters, that is,
\eqn{\mu}, \eqn{\sigma} and \eqn{\xi}. Otherwise, \code{parm} must be a subset
of \code{c("mu", "sigma", "xi")}.}

\item{level}{The confidence level required.  A numeric scalar in (0, 1).}

\item{profile}{A logical scalar. If \code{TRUE} then confidence intervals
based on a profile log-likelihood are returned.  If \code{FALSE} then intervals
based on approximate large sample normal theory, which are symmetric about
the MLE, are returned.}

\item{mult}{A positive numeric scalar. Controls the increment by which the
parameter of interest is increased/decreased when profiling above/below
its MLE. The increment is \code{mult * se / 100} where \code{se} is the estimated
standard error of the estimator of the parameter. Decreasing \code{mult}
profiles at more points but will be slower. The default, \code{mult = 2} should
be sufficiently small to produce a smooth looking plot of the profile
log-likelihood using \code{\link{plot.confint_gev}}. To estimate the confidence
limits more quickly, the value of \code{mult} can be increased and/or the
argument \code{faster} set to \code{TRUE}.}

\item{faster}{A logical scalar. If \code{faster = TRUE} then the profiling of the
log-likelihood in search of a lower (upper) confidence limit is started at
the corresponding symmetric lower (upper) confidence limit.}

\item{epsilon}{Only relevant if \code{profile = TRUE}. A numeric vector of values
that determine the accuracy of the confidence limits. \code{epsilon} is
recycled to the length of the parameter vector \code{parm}.
\itemize{
\item If \code{epsilon[i] > 0} then this value is passed as the argument \code{epsilon}
to the \code{\link[itp:itp]{itp::itp}} function, which estimates the parameter values for
which the profile log-likelihood for parameter \code{i} drops to the value
that defines the confidence limits, once profiling has been successful
in finding an interval within which this value lies.
\item If \code{epsilon[i] < 0} quadratic interpolation is used, which will tend to
be faster.
\item If \code{epsilon[i] = 0} then linear interpolation is used, which will be
faster still.
}}

\item{adjust}{If \code{adjust = TRUE} then the diagnostic plots produced by
\code{plot.evmissing} are adjusted for the number of non-missing observations
contributing to each block maximum. Otherwise, no adjustment is made.}

\item{which}{If supplied, this must either be a character scalar, one of
\code{"pp"}, \code{"qq"}, \code{"return"} or \code{"density"} or a numeric scalar in \code{1:4},
with \code{1} corresponding to \code{"pp"} etc. If \code{which} is missing then all four
plots are produced in a 2 by 2 display.}

\item{m}{A numeric vector of return periods to label on the
horizontal axis of the \strong{return level plot}. Along with the data, the
smallest and largest return period values in \code{m} influence the range of
return periods for which return level estimates are plotted. All values in
\code{m} must be greater than 1.}

\item{num}{An integer scalar. The number of return level estimates to
calculate to produce the return level curve and pointwise confidence
limits in the \strong{return level plot}. The default setting is approximately
5 times \code{log(max(m), base = 10)}. If \code{profile = TRUE} then reducing \code{num}
will speed up the calculation of the confidence limits, at the expense of
a reduction in smoothness of the curves.}

\item{npy}{A numeric scalar.  The number \eqn{n_{py}} of block maxima per
year. If the blocks are of length 1 year then \code{npy = 1}. This is only
used in the \strong{return level plot}.}
}
\value{
\code{coef.evmissing}: a numeric vector of length 3 with names
\code{c("mu", "sigma", "xi")}.  The MLEs of the parameters \eqn{\mu},
\eqn{\sigma} and \eqn{\xi}.

\code{vcov.evmissing}: a \eqn{3 \times 3}{3 x 3} matrix with row and column
names \code{c("mu", "sigma", "xi")}. The estimated variance-covariance matrix
for the model parameters \eqn{\mu}, \eqn{\sigma} and \eqn{\xi}.

\code{nobs.evmissing}: a numeric scalar. The number of maxima used in the model
fit.

\code{logLik.evmissing}: an object of class \code{"logLik"}: a numeric scalar
with value equal to the maximised log-likelihood. The returned object
also has attributes \code{nobs}, the number of maxima used in the model fit
and \code{"df"} (degrees of freedom), which is equal to the number of total
number of parameters estimated (3).

\code{summary.evmissing}: an object with class \code{"summary.evmissing"} containing
the original function call and a matrix of estimates and estimated
standard errors with row names \code{c("mu", "sigma", "xi")}.  The object is
printed by \code{\link{print.summary.evmissing}}.

\code{print.summary.evmissing}: the argument \code{x} is returned, invisibly.

\code{confint.evmissing}: an object of class \code{c("confint_gev", "evmissing")}.
A numeric matrix with 2 columns giving the lower and upper confidence
limits for each parameter. These columns are labelled as \code{(1-level)/2} and
\code{1-(1-level)/2}, expressed as a percentage, by default \verb{2.5\%} and \verb{97.5\%}.
The row names are the names of the parameters supplied in \code{parm}.
The ordering \code{"mu"}, \code{"sigma"}, \code{"xi"} is retained regardless of the
ordering of the parameters in \code{parm}.
If \code{profile = TRUE} then the returned object has extra attributes \code{crit},
\code{level} and \code{for_plot}. The latter is a named list of length 3 with
components \code{mu}, \code{sigma} and \code{xi}. Each components is a 2-column numeric
matrix. The first column (named \code{mu_values} etc) contains values of the
parameter and the second column the corresponding values of the profile
log-likelihood. The profile log-likelihood is equal to the attribute
\code{crit} at the limits of the confidence interval. The attribute \code{level} is
the input argument \code{level}.

\code{plot.evmissing}: if a return level plot has been requested, a 3-column
matrix containing the values plotted in the return level plot. Column 2
contains the estimated return levels and columns 1 and 3 the lower and
upper confidence limits.
}
\description{
Methods for objects of class \code{"evmissing"} returned from \code{\link{gev_mle}}.
}
\details{
The plots produced by \code{plot.evmissing} are of a similar form to the
visual diagnostics is the \code{ismev} package and described in Coles (2001),
that is, a probability plot (\code{which = "pp"} or \code{which = 1}), a quantile
plot (\code{which ="qq"} of \code{which = 2}), a return level plot
(\code{which = "return"} or \code{which = 3}) and a histogram of block maxima with a
fitted GEV density superimposed (\code{which = "density"} or \code{which = 4}).
Pointwise confidence bands of level \code{level} are added to the probability
plot and quantile plot.

The default setting for confidence intervals for a return level plot
produced by \code{plot.evmissing} is \code{profile = TRUE}, which uses \code{\link{gev_return}}
and \code{\link{confint.return_level}}. The plot takes longer to produce, but it
avoids the unrealistic feature of the lower confidence limits decreasing
as we extrapolate to long return periods.

If \code{adjust = TRUE} then the empirical values based on the observed block
maxima are adjusted for the number of non-missing raw observations in
each block based on the fitted GEV parameter values for reduced block
sizes. Passing \code{adjust = FALSE} is not sensible, but, if there are missing
data, then it can serve to show that making the adjustment is necessary to
give the correct impression of how well the model has fitted the data.

For \code{confint.evmissing}, the default, \code{epsilon = -1}, should work well
enough in most circumstances, but to achieve a specific accuracy set
\code{epsilon} to be a small positive value, for example, \code{epsilon = 1e-4}.
}
\examples{
## Plymouth ozone data

# Make adjustment for the numbers of non-missing values per block
fit <- gev_mle(PlymouthOzoneMaxima)
coef(fit)
vcov(fit)
nobs(fit)
logLik(fit)
summary(fit)

## Model diagnostic plots

# When profile = FALSE the return confidence limits are unrealistic
# for long return periods
plot(fit, profile = FALSE)

# Create the return level plot only
# When profile = TRUE (the default) the confidence limits are fine
# but the plot takes longer
# For speed, we reduce the number, num, of points used to plot the curves
plot(fit, which = 3, num = 8)

# If we do not reflect the adjustment in the plot then it gives a false
# impression of how well the model has fitted the data
plot(fit, adjust = FALSE, profile = FALSE)

## Confidence intervals

# Confidence limits that are symmetric about the respective MLEs
confint(fit)

# Calling confint to produce a smooth profile log-likelihood plot
x <- confint(fit, profile = TRUE)
x
plot(x, parm = "xi")

# Doing this more quickly when we only want the approximate confidence limits
x <- confint(fit, profile = TRUE, mult = 32, faster = TRUE)
x
plot(x, parm = "xi", type = "b")
}
\references{
Coles, S. G. (2001) \emph{An Introduction to Statistical
Modeling of Extreme Values}, Springer-Verlag, London.
\doi{10.1007/978-1-4471-3675-0_3}

Heffernan, J. E. and Stephenson, A. G. (2018). \emph{ismev: An
Introduction to Statistical Modeling of Extreme Values}. R package version
1.42. \doi{10.32614/CRAN.package.ismev}
}
\seealso{
\code{\link{gev_mle}} and \code{\link{confint_gev_methods}}.
}
