% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_evanverse_discrete.R
\name{scale_evanverse}
\alias{scale_evanverse}
\alias{scale_color_evanverse}
\alias{scale_fill_evanverse}
\alias{scale_colour_evanverse}
\title{Discrete Color and Fill Scales for evanverse Palettes}
\usage{
scale_color_evanverse(
  palette,
  type = NULL,
  n = NULL,
  reverse = FALSE,
  na.value = "grey50",
  guide = "legend",
  ...
)

scale_fill_evanverse(
  palette,
  type = NULL,
  n = NULL,
  reverse = FALSE,
  na.value = "grey50",
  guide = "legend",
  ...
)

scale_colour_evanverse(
  palette,
  type = NULL,
  n = NULL,
  reverse = FALSE,
  na.value = "grey50",
  guide = "legend",
  ...
)
}
\arguments{
\item{palette}{Character. Name of the palette (e.g., "qual_vivid", "seq_blues").
Type will be automatically inferred from the prefix if not specified.}

\item{type}{Character. Palette type: "sequential", "diverging", or "qualitative".
If \code{NULL} (default), the type is automatically inferred from the palette
name prefix.}

\item{n}{Integer. Number of colors to use. If \code{NULL} (default), all
colors from the palette are used. If \code{n} exceeds the number of colors
in the palette, an error will be raised.}

\item{reverse}{Logical. Should the color order be reversed? Default is \code{FALSE}.}

\item{na.value}{Character. Color to use for \code{NA} values. Default is "grey50".}

\item{guide}{Character or function. Type of legend. Use "legend" for standard
legend or "none" to hide the legend. See \code{\link[ggplot2]{guide_legend}}
for more options.}

\item{...}{Additional arguments passed to \code{\link[ggplot2]{scale_color_manual}}
or \code{\link[ggplot2]{scale_fill_manual}}, such as \code{name}, \code{labels},
\code{limits}, etc.}
}
\value{
A ggplot2 scale object that can be added to a ggplot.
}
\description{
Apply evanverse color palettes to ggplot2 discrete scales. These functions
provide a seamless integration between evanverse palettes and ggplot2's
color/fill aesthetics.
}
\details{
The \code{scale_color_evanverse()} and \code{scale_fill_evanverse()}
functions automatically:
\itemize{
\item Infer palette type from the naming convention (seq_, div_, qual_)
\item Handle color interpolation intelligently based on palette type:
\itemize{
\item \strong{Qualitative palettes}: Direct color selection (no interpolation)
\item \strong{Sequential/Diverging palettes}: Smooth interpolation when n < palette size
}
\item Support all standard ggplot2 scale parameters
\item Provide informative error messages and warnings
}
}
\examples{
library(ggplot2)

# Basic usage with automatic type inference
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point(size = 3, alpha = 0.8) +
  scale_color_evanverse("qual_vivid") +
  theme_minimal()

# Fill scale for boxplots
ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_boxplot(alpha = 0.7) +
  scale_fill_evanverse("qual_vivid") +
  theme_minimal()

# Reverse color order
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point(size = 3) +
  scale_color_evanverse("qual_vivid", reverse = TRUE) +
  theme_minimal()

# Explicitly specify type
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point(size = 3) +
  scale_color_evanverse("qual_vivid", type = "qualitative") +
  theme_minimal()

# Limit number of colors
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point(size = 3) +
  scale_color_evanverse("qual_vivid", n = 3) +
  theme_minimal()

# Custom legend name and labels
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point(size = 3) +
  scale_color_evanverse(
    "qual_vivid",
    name = "Iris Species",
    labels = c("Setosa", "Versicolor", "Virginica")
  ) +
  theme_minimal()

# Bar plot with fill
ggplot(mtcars, aes(x = factor(cyl), fill = factor(cyl))) +
  geom_bar() +
  scale_fill_evanverse("qual_vibrant") +
  labs(x = "Cylinders", y = "Count", fill = "Cylinders") +
  theme_minimal()

}
\seealso{
\code{\link{get_palette}} for retrieving palette colors,
\code{\link{list_palettes}} for available palettes,
\code{\link[ggplot2]{scale_color_manual}} for the underlying ggplot2 function.
}
