% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\name{pkg_management}
\alias{pkg_management}
\title{Package Management}
\description{
A unified interface for R package management across CRAN, GitHub,
Bioconductor, and local sources. Provides consistent installation,
checking, updating, and querying capabilities.
}
\details{
The package management functions automatically:
\itemize{
\item Respect mirror settings configured via \code{set_mirror()}
\item Handle dependencies for BiocManager and devtools
\item Validate package names and sources
\item Provide informative error messages and progress updates
}

Recommended workflow:
\enumerate{
\item (Optional) Configure mirrors: \code{set_mirror()}
\item Install packages: \code{inst_pkg()}
\item Check status: \code{check_pkg()}
\item Update packages: \code{update_pkg()}
\item Query information: \code{pkg_version()}, \code{pkg_functions()}
}
}
\seealso{
\code{\link[utils]{install.packages}} for base installation,
\code{\link[devtools]{install_github}} for GitHub packages,
\code{\link[BiocManager]{install}} for Bioconductor packages.
}
