% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erviss_ili_ari_rates.R
\name{plot_ili_ari_rates}
\alias{plot_ili_ari_rates}
\title{Plot ERVISS ILI/ARI consultation rates data}
\usage{
plot_ili_ari_rates(data, date_breaks = "2 weeks", date_format = "\%b \%Y")
}
\arguments{
\item{data}{A data.table or data.frame containing ILI/ARI rates data, typically
output from \code{\link{get_ili_ari_rates}}. Must contain columns: date, value,
age, countryname.}

\item{date_breaks}{A string specifying the date breaks for the x-axis
(e.g., "1 month", "2 weeks")}

\item{date_format}{A string specifying the date format for x-axis labels
(e.g., \code{"\%b \%Y"} for "Jan 2024")}
}
\value{
A ggplot2 object
}
\description{
Creates a ggplot2 visualization of ILI/ARI consultation rates, with facets
by country and colored by age group.
}
\examples{
\donttest{
data <- get_ili_ari_rates(
  date_min = as.Date("2024-01-01"),
  date_max = as.Date("2024-06-30"),
  indicator = "ILIconsultationrate"
)
plot_ili_ari_rates(data, date_breaks = "1 month")
}
}
