% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_functions.R,
%   R/binary_method_functions.R, R/continuous_method_functions.R,
%   R/ordinal_method_functions.R
\name{estimate_ML}
\alias{estimate_ML}
\alias{estimate_ML_binary}
\alias{estimate_ML_continuous}
\alias{estimate_ML_ordinal}
\title{Estimate maximum likelihood accuracy statistics by expectation maximization}
\usage{
estimate_ML(
  type = c("binary", "ordinal", "continuous"),
  data,
  freqs = NULL,
  init = list(NULL),
  max_iter = 1000,
  tol = 1e-07,
  save_progress = TRUE,
  ...
)

estimate_ML_binary(
  data,
  freqs = NULL,
  init = list(prev_1 = NULL, se_1 = NULL, sp_1 = NULL),
  max_iter = 1000,
  tol = 1e-07,
  save_progress = TRUE
)

estimate_ML_continuous(
  data,
  freqs = NULL,
  init = list(prev_1 = NULL, mu_i1_1 = NULL, sigma_i1_1 = NULL, mu_i0_1 = NULL,
    sigma_i0_1 = NULL),
  max_iter = 100,
  tol = 1e-07,
  save_progress = TRUE
)

estimate_ML_ordinal(
  data,
  freqs = NULL,
  init = list(pi_1_1 = NULL, phi_1ij_1 = NULL, phi_0ij_1 = NULL, n_level = NULL),
  level_names = NULL,
  max_iter = 1000,
  tol = 1e-07,
  save_progress = TRUE
)
}
\arguments{
\item{type}{A string specifying the data type of the methods under evaluation.}

\item{data}{An \code{n_obs} by \code{n_method} \code{\link{matrix}} containing the
observed values for each method. If the dimensions are named, row names will
be used to name each observation (\code{obs_names}) and column names will be used
to name each measurement method (\code{method_names}).}

\item{freqs}{A vector of elements \code{n_obs} long representing the number of times
each row in \code{data} was observed. Used when \code{data} is a summary of unique response
combinations.}

\item{init}{An optional list of initial values used to seed the EM algorithm.
If initial values are not provided, the \code{pollinate_ML()} function will be
called on the data to estimate starting values. It is recommended to try several
sets of starting parameters to ensure that the algorithm converges to the same
results. This is to verify that the result does not represent a local extrema.}

\item{max_iter}{The maximum number of EM algorithm iterations to compute before
reporting a result.}

\item{tol}{The minimum change in statistic estimates needed to continue
iterating the EM algorithm.}

\item{save_progress}{A logical indication of whether to save interim
calculations used in the EM algorithm.}

\item{...}{Additional arguments}

\item{level_names}{An optional, ordered, character vector of unique names corresponding to
the levels of the methods.}
}
\value{
\code{estimate_ML()} returns an S4 object of class "MultiMethodMLEstimate"
containing the maximum likelihood accuracy statistics calculated by EM.
}
\description{
\code{estimate_ML()} is a general function for estimating the maximum likelihood accuracy
statistics for a set of methods with no known reference value, i.e. "truth", or
"gold standard".
}
\details{
The lack of an infallible reference method is referred to
as an imperfect gold standard (GS). Accuracy statistics which rely on a GS
method, such as sensitivity, specificity, and AUC,
can be estimated using imperfect gold standards by iteratively estimating the
maximum likelihood values of these statistics while the conditional independence
assumption holds. \code{estimate_ML()} relies on a collection of expectation maximization (EM) algorithms
to achieve this. The EM algorithms used in this function are based on those presented in
\emph{Statistical Methods in Diagnostic Medicine, Second Edition}
\insertCite{Zhou_Obuchowski_McClish_2011}{emery} and have been validated on
several examples therein. Additional details about these algorithms can be found
for binary \insertCite{Walter1988-oq}{emery}, ordinal \insertCite{Zhou2005-gk}{emery},
and continuous \insertCite{Hsieh_Su_Zhou_2011}{emery} methods.
Minor changes to the literal calculations have been
made for efficiency, code readability, and the like, but the underlying steps
remain functionally unchanged.
}
\examples{
# Set seed for this example
set.seed(11001101)

# Generate data for 4 binary methods
my_sim <- generate_multimethod_data(
  "binary",
  n_obs = 75,
  n_method = 4,
  se = c(0.87, 0.92, 0.79, 0.95),
  sp = c(0.85, 0.93, 0.94, 0.80),
  method_names = c("alpha", "beta", "gamma", "delta"))

# View the data
my_sim$generated_data

# View the parameters used to generate the data
my_sim$params

# Estimate ML accuracy values by EM algorithm
my_result <- estimate_ML(
  "binary",
  data = my_sim$generated_data,
  save_progress = FALSE # this reduces the data stored in the resulting object
)

# View results of ML estimate
my_result@results

}
\references{
\insertRef{Zhou_Obuchowski_McClish_2011}{emery}

\insertRef{Walter1988-oq}{emery}

\insertRef{Zhou2005-gk}{emery}

\insertRef{Hsieh_Su_Zhou_2011}{emery}
}
