% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_RTI.R
\name{calculate_RTI}
\alias{calculate_RTI}
\title{Calculate Road Tolerance Index (RTI)}
\usage{
calculate_RTI(occurrences, roads, ref_dist = 3.5)
}
\arguments{
\item{occurrences}{Um objeto \code{sf} contendo as ocorrências já
processadas (output de \code{process_occurrences()}).}

\item{roads}{Um objeto \code{sf} contendo a rede de estradas.}

\item{ref_dist}{Distância de referência em quilômetros (padrão = 3.5).}
}
\value{
Uma lista com:
\describe{
\item{data}{O objeto \code{sf} de ocorrências, porém com uma nova
coluna \code{RTI_value} com o índice calculado.}
\item{RTI}{Um data frame com a mediana de RTI por espécie.}
}
}
\description{
Esta função calcula o RTI para cada ocorrência de espécie com base
na distância mínima até a estrada mais próxima. A fórmula usada é:
\deqn{ RTI = \frac{ref\_dist}{dist + ref\_dist} }
}
\details{
Se \code{dist} = 0, então RTI = 1. Conforme \code{dist} aumenta, RTI
aproxima-se de 0.
}
\examples{
# Carregar rodovias de exemplo (Toy data)
roads <- load_roads()

# Criar dados de ocorrencia ficticios na area do Toy Data
occ_data <- data.frame(
  species = "SpA", 
  longitude = -38.4, 
  latitude = -12.6
)

# Processar ocorrencias
processed <- process_occurrences(occ_data)

# Calcular RTI
rti_res <- calculate_RTI(processed, roads, ref_dist = 3.5)
}
