% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_HFTI.R
\name{calculate_HFTI}
\alias{calculate_HFTI}
\title{Calculate Human Footprint Tolerance Index (HFTI)}
\usage{
calculate_HFTI(occurrences, footprint, divisor = 50, buffer_m = 1000)
}
\arguments{
\item{occurrences}{An sf object containing processed occurrences.}

\item{footprint}{A RasterLayer containing human footprint values.}

\item{divisor}{A numeric value to divide the footprint by (default = 50).}

\item{buffer_m}{Numeric. Buffer size in meters for footprint extraction (default = 1000).}
}
\value{
A list with:
\describe{
\item{data}{The sf object of occurrences with a new column \code{HFTI_value}.}
\item{HFTI}{A data frame with the median HFTI per species.}
}
}
\description{
This function calculates the HFTI for each species occurrence based on
the average human footprint within a 1 km buffer around each occurrence.
}
\examples{
# Note: simple example using the internal "toy" data
footprint <- load_human_footprint()
# We need dummy occurrence data for the example to run
occ_data <- data.frame(species = "SpA", longitude = -38.4, latitude = -12.6)
processed <- process_occurrences(occ_data)
hfti_result <- calculate_HFTI(processed, footprint, divisor = 50, buffer_m = 1000)
}
