% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-base.R
\name{summary.tune_esn}
\alias{summary.tune_esn}
\title{Provide a summary of the hyperparameter tuning}
\usage{
\method{summary}{tune_esn}(object, metric = "mse", ...)
}
\arguments{
\item{object}{An object of class \code{tune_esn}. The result of a call to \code{tune_esn()}.}

\item{metric}{Character value. The metric used to select the best hyperparameter combination (\code{metric = c("mse", "mae")}.}

\item{...}{Currently not in use.}
}
\value{
Print detailed model summary.
}
\description{
Provide a summary of the tuned hyperparameters \code{alpha}, 
  \code{rho} and \code{tau}.
}
\examples{
xdata <- as.numeric(AirPassengers)
fit <- tune_esn(
  y = xdata,
  n_ahead = 12,
  n_split = 5,
  alpha = c(0.5, 1),
  rho   = c(1.0),
  tau   = c(0.4),
  inf_crit = "bic"
)

summary(fit)

}
\seealso{
Other base functions: 
\code{\link{forecast_esn}()},
\code{\link{is.esn}()},
\code{\link{is.forecast_esn}()},
\code{\link{is.tune_esn}()},
\code{\link{plot.esn}()},
\code{\link{plot.forecast_esn}()},
\code{\link{plot.tune_esn}()},
\code{\link{print.esn}()},
\code{\link{summary.esn}()},
\code{\link{train_esn}()},
\code{\link{tune_esn}()}
}
\concept{base functions}
